/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.vo.MosPVo;

public class ReasonMenuVo extends MosPVo {

	private static final long serialVersionUID = -7119280363435819674L;
	
	// URL
	private static final String RETURN_URL = "/jsp/system/reasonMenu.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/reasonMenu.js";
	private static final String EXTRA_CSS  = "/pub/system/css/reasonMenu.css";

	// ʃTu^Cg	
	public final String CMD_REASON_MENU 			= "S2590";
	public final String TTL_REASON_MENU_MASTER 	= CommonConst.TTL_REASON_MENU_MASTER;

	/**
	 * RXgN^
	 */
	public ReasonMenuVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
	}

}
